<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header("Content-Type: application/json");

include '../db.php'; // Make sure this still points correctly

$data = json_decode(file_get_contents("php://input"), true);

$callsign = $data['callsign'] ?? '';
$status = $data['status'] ?? '';
$evNumber = $data['evNumber'] ?? '';
$location = $data['location'] ?? '';

if (!$callsign) {
  echo json_encode(['success' => false, 'error' => 'Missing callsign']);
  exit;
}

// DEBUG LOGGING
file_put_contents("unit_log.txt", print_r($data, true), FILE_APPEND);

// Check if unit exists and is locked
$stmt = $pdo->prepare("SELECT dispatcher FROM units WHERE callsign = ?");
$stmt->execute([$callsign]);
$existing = $stmt->fetch(PDO::FETCH_ASSOC);

if ($existing && $existing['dispatcher'] !== $dispatcher && !$isPriority) {
  echo json_encode([
    'success' => false,
    'error' => 'This unit is currently controlled by another dispatcher.'
  ]);
  exit;
}

// Proceed with insert or update
$stmt = $pdo->prepare("
  INSERT INTO units (callsign, status, evNumber, location, dispatcher)
  VALUES (?, ?, ?, ?, ?)
  ON DUPLICATE KEY UPDATE
    status = VALUES(status),
    evNumber = VALUES(evNumber),
    location = VALUES(location),
    dispatcher = VALUES(dispatcher)
");

$success = $stmt->execute([$callsign, $status, $evNumber, $location, $dispatcher]);

echo json_encode(['success' => $success]);
?>
