<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
include '../db.php';

$data = json_decode(file_get_contents("php://input"), true);
$evNumber = $data['evNumber'] ?? '';
$index = $data['index'] ?? -1;
$dispatcher = $data['dispatcherId'] ?? 'unknown';
$isPriority = $data['priority'] ?? false;

if (!$evNumber || $index < 0) {
  echo json_encode(['success' => false, 'error' => 'Invalid input']);
  exit;
}

$get = $conn->prepare("SELECT notes FROM events WHERE evNumber = ?");
$get->bind_param("s", $evNumber);
$get->execute();
$result = $get->get_result();

if ($result->num_rows === 0) {
  echo json_encode(['success' => false, 'error' => 'Event not found']);
  exit;
}

$row = $result->fetch_assoc();
$notes = json_decode($row['notes'], true);

if (!$isPriority) {
  echo json_encode(['success' => false, 'error' => 'You do not have priority to delete notes.']);
  exit;
}

array_splice($notes, $index, 1);
$updated = json_encode($notes);

$update = $conn->prepare("UPDATE events SET notes = ? WHERE evNumber = ?");
$update->bind_param("ss", $updated, $evNumber);
$update->execute();

echo json_encode(['success' => true, 'notes' => $notes]);
?>