<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
include '../db.php';

header("Content-Type: application/json");

try {
  $stmt = $pdo->query("SELECT * FROM events ORDER BY evNumber DESC");
  $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Convert notes field from JSON string to array
foreach ($results as &$event) {
  if (isset($event['notes']) && is_string($event['notes'])) {
    $decoded = json_decode($event['notes'], true);
    $event['notes'] = is_array($decoded) ? $decoded : [];
  } else {
    $event['notes'] = [];
  }
}
  echo json_encode($results);
} catch (Exception $e) {
  echo json_encode(['error' => $e->getMessage()]);
}
?>