<?php
// reset_cad.php
// (1) Include your PDO connection
include '../db.php';

// (2) Optional: log each run so you can verify via cron_test.log
file_put_contents(__DIR__ . '/cron_test.log',
    "Reset started at " . date('Y-m-d H:i:s') . "\n",
    FILE_APPEND
);

try {
    // (3) Delete from child tables first:
    $pdo->exec("DELETE FROM notes");
    $pdo->exec("DELETE FROM units");

    // (4) Clear any file-based logs you keep for units
    file_put_contents(__DIR__ . '/unit_log.txt', '');

    // (5) Now delete from the parent events table
    $pdo->exec("DELETE FROM events");

    echo "CAD reset successful at " . date('Y-m-d H:i:s');
} catch (PDOException $e) {
    echo "Error resetting CAD: " . $e->getMessage();
}

file_put_contents(__DIR__ . '/last_reset.txt', time());
